#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Programme de transcription-traduction d'une séquence ADN

Pour utiliser le programme, il faut l'exécuter dans la console d'exécution.
Ensuite, il suffit d'appeler la fonction traduction en notant entre parenthèses
et entre guillements la séquence d'ADN à transcrire et traduire en mettant 
un espace entre chaque codon.
Ex: traduction ("TAC GAG TCG ACT")

Pour comprendre ce que fait chaque ligne de code, 
aller sur http://pythontutor.com/visualize.html#mode=edit
Copier/Coller le programme et exécuter-le (en rajoutant
traduction ("TAC GAG TCG ACT") après la dernière ligne)

@auteur: Sébastien LECOT Sebastien.Lecot1@ac-rennes.fr
"""
code_genetique = {"UUU":"Phe", "UUC":"Phe", "UUA":"Leu", "UUG":"Leu", 
                  "UCC":"Ser", "UCG":"Ser", "UCA":"Ser", "UCU":"Ser", 
                  "UAU":"Tyr", "UAC":"Tyr", "UGC":"Cys", "UGU":"Cys",
                  "CUU":"Leu", "CUC":"Leu", "CUG":"Leu", "CUA":"Leu",
                  "CCU":"Pro", "CCC":"Pro", "CCG":"Pro", "CCA":"Pro",
                  "CAU":"His", "CAC":"His", "CAG":"Gln", "CAA":"Gln",
                  "CGU":"Arg", "CGC":"Arg", "CGG":"Arg", "CGA":"Arg",
                  "AUU":"Ile", "AUC":"Ile", "AUG":"Met", "AUA":"Ile",
                  "ACU":"Thr", "ACC":"Thr", "ACG":"Thr", "ACA":"Thr",
                  "AAU":"Asn", "AAC":"Asn", "AAG":"Lys", "AAA":"Lys",
                  "AGU":"Ser", "AGC":"Ser", "AGG":"Arg", "AGA":"Arg",
                  "GUU":"Val", "GUC":"Val", "GUG":"Val", "GUA":"Val",
                  "GCU":"Ala", "GCC":"Ala", "GCG":"Ala", "GCA":"Ala",
                  "GAU":"Asp", "GAC":"Asp", "GAG":"Glu", "GAA":"Glu",
                  "GGU":"Gly", "GGC":"Gly", "GGG":"Gly", "GGA":"Gly"}

def transcription (ADN): 
    ARN = "" 
    for i in range (len(ADN)): 
        if ADN[i] == "A": 
            ARN = ARN + "U" 
        elif ADN[i] == "T": 
            ARN = ARN + "A" 
        elif ADN[i] == "C": 
            ARN = ARN + "G" 
        elif ADN[i] == "G":
            ARN = ARN + "C"
        else:
            ARN = ARN + " " 
    return ARN

def traduction (ADN):
    ARN = transcription (ADN) 
    sequenceARN = ARN.split() 
    proteine = [] 
    for aa in sequenceARN: 
        if aa in code_genetique:  
            proteine.append(code_genetique[aa]) 
        else: 
            print ("ADN =", ADN)
            print ("ARNm =", ARN) 
            print ("Séquence en aa =", "-".join(proteine))
    return 
